<?php
session_start();
require __DIR__ . '/../shared/db.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'user') {
  header("Location: ../login.php");
  exit;
}
$user_id = $_SESSION['user']['id'];
$username_web = $_SESSION['user']['username'];

$servers = $pdo->query("SELECT * FROM vpn_servers")->fetchAll();
$accounts = $pdo->prepare("SELECT a.*, s.name as server_name FROM vpn_accounts a
  JOIN vpn_servers s ON a.server_id = s.id WHERE user_id = ?");
$accounts->execute([$user_id]);
$vpn_accounts = $accounts->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $server_id = $_POST['server_id'];
  $vpn_user = $_POST['vpn_username'];
  $vpn_pass = $_POST['vpn_password'];
  $action = $_POST['action'];

  $server = $pdo->prepare("SELECT * FROM vpn_servers WHERE id = ?");
  $server->execute([$server_id]);
  $srv = $server->fetch();

  $url = "http://{$srv['ip_address']}:{$srv['api_port']}/$action";
  $auth = base64_encode("{$srv['api_user']}:" . base64_decode($srv['api_pass']));
  $data = ['username' => $vpn_user];
  if ($action === 'add-user') $data['password'] = $vpn_pass;

  $opts = ['http' => [
    'method' => 'POST',
    'header' => ["Authorization: Basic $auth", "Content-Type: application/json"],
    'content' => json_encode($data)
  ]];
  $ctx = stream_context_create($opts);
  $res = file_get_contents($url, false, $ctx);

  // Simpan jika berhasil
  if ($res && $action === 'add-user') {
    $stmt = $pdo->prepare("INSERT INTO vpn_accounts (user_id, server_id, username, vpn_ip, expired_at) VALUES (?, ?, ?, ?, DATE_ADD(NOW(), INTERVAL 30 DAY))");
    $json = json_decode($res, true);
    $stmt->execute([$user_id, $server_id, $vpn_user, $json['vpn_ip'] ?? null]);
  }
  if ($res && $action === 'delete-user') {
    $pdo->prepare("DELETE FROM vpn_accounts WHERE user_id = ? AND username = ?")->execute([$user_id, $vpn_user]);
  }

  header("Location: dashboard_user.php");
  exit;
}
?>
<!DOCTYPE html><html><head><title>Akun VPN Saya</title><link rel="stylesheet" href="../shared/assets/style.css"></head><body>
<div class="container">
<h2>Halo, <?= htmlspecialchars($username_web) ?>!</h2>
<p><a href="index.php">← Kembali</a> | <a href="../logout.php">Logout</a></p>

<form method="POST" class="mt-4">
  <input type="hidden" name="action" value="add-user">
  <input type="text" name="vpn_username" required placeholder="Username VPN">
  <input type="text" name="vpn_password" required placeholder="Password VPN">
  <select name="server_id" required>
    <option value="">Pilih Server</option>
    <?php foreach ($servers as $s): ?>
    <option value="<?= $s['id'] ?>"><?= $s['name'] ?> - <?= $s['ip_address'] ?></option>
    <?php endforeach; ?>
  </select>
  <button type="submit">Buat Akun VPN</button>
</form>

<h3 class="mt-6">Akun VPN Anda</h3>
<table><tr><th>Username</th><th>Server</th><th>IP</th><th>Expired</th><th>Aksi</th></tr>
<?php foreach ($vpn_accounts as $a): ?>
<tr>
  <td><?= $a['username'] ?></td>
  <td><?= $a['server_name'] ?></td>
  <td><?= $a['vpn_ip'] ?></td>
  <td><?= $a['expired_at'] ?></td>
  <td>
    <form method="POST" style="display:inline;">
      <input type="hidden" name="vpn_username" value="<?= $a['username'] ?>">
      <input type="hidden" name="server_id" value="<?= $a['server_id'] ?>">
      <input type="hidden" name="action" value="delete-user">
      <button type="submit" onclick="return confirm('Yakin hapus akun VPN ini?')">🗑 Delete</button>
    </form>
  </td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body></html>
