<?php
session_start();
require __DIR__ . '/shared/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = $_POST['username'];
  $email = $_POST['email'];
  $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

  $stmt = $pdo->prepare("INSERT INTO web_users (username, email, password, role) VALUES (?, ?, ?, 'user')");
  try {
    $stmt->execute([$username, $email, $password]);
    $user_id = $pdo->lastInsertId();
    $pdo->prepare("INSERT INTO balances (user_id, amount) VALUES (?, 0)")->execute([$user_id]);
    $_SESSION['user'] = [
      'id' => $user_id,
      'username' => $username,
      'role' => 'user',
      'email' => $email
    ];
    header("Location: index.php");
    exit;
  } catch (PDOException $e) {
    $error = "Registrasi gagal: Username atau email mungkin sudah digunakan.";
  }
}
?>
<!DOCTYPE html>
<html><head><title>Register</title><link rel="stylesheet" href="assets/style.css"></head><body>
<div class="container">
<h2>Daftar Akun VPN</h2>
<?php if (isset($error)) echo "<p style='color:red;'>$error</p>"; ?>
<form method="POST">
  <input type="text" name="username" placeholder="Username" required>
  <input type="email" name="email" placeholder="Email aktif" required>
  <input type="password" name="password" placeholder="Password" required>
  <button type="submit">Daftar</button>
</form>
<p>Sudah punya akun? <a href="login.php">Login</a></p>
</div>
</body></html>
